﻿Shader "CrossSection/OnePlaneBSP" {
	Properties{
		_Color("Color", Color) = (1,1,1,1)
		_CrossColor("Cross Section Color", Color) = (1,1,1,1)
		_MainTex("Albedo (RGB)", 2D) = "white" {}
		_Glossiness("Smoothness", Range(0,1)) = 0.5
		_Metallic("Metallic", Range(0,1)) = 0.0
		_PlaneNormal("PlaneNormal",Vector) = (0,1,0,0)
		_PlanePosition("PlanePosition",Vector) = (0,0,0,1)
		_StencilMask("Stencil Mask", Range(0, 255)) = 255
	}
	SubShader {
		Tags { "RenderType"="Opaque" }
		//LOD 200
		Stencil
		{
			Ref [_StencilMask]
			CompBack Always
			PassBack Replace

			CompFront Always
			PassFront Zero
		}
		Cull Back
			CGPROGRAM
			// Physically based Standard lighting model, and enable shadows on all light types
#pragma surface surf Standard fullforwardshadows

			// Use shader model 3.0 target, to get nicer looking lighting
#pragma target 3.0

			sampler2D _MainTex;

		struct Input {
			float2 uv_MainTex;

			float3 worldPos;
		};

		half _Glossiness;
		half _Metallic;
		fixed4 _Color;
		fixed4 _CrossColor;
		fixed3 _PlaneNormal;
		fixed3 _PlanePosition;
		bool checkVisability(fixed3 worldPos)
		{
			//float3 tmp1 = (worldPos.x, worldPos.y - 0.05, worldPos.z);
			//float3 tmp2 = (0, worldPos.y - 0.05, 0);
			float x1 = abs(worldPos.x - _PlanePosition.x);
			float z1 = abs(worldPos.z - _PlanePosition.z);
			float y1 = abs(_PlanePosition.y - worldPos.y);
			bool wow = ((x1 * x1) + (z1 * z1)) < ((y1 + 0.08) * (y1 + 0.08)) && ((x1 * x1) + (z1 * z1)) > ((y1) * (y1));
			//float dotProd1 = tmp.y;
			return (worldPos.y > _PlanePosition.y) || !wow;
			//float dotProd1 = dot(worldPos - _PlanePosition, _PlaneNormal);
			//return dotProd1 > 0  ;
		}
		void surf(Input IN, inout SurfaceOutputStandard o) {
			if (checkVisability(IN.worldPos))discard;
			fixed4 c = tex2D(_MainTex, IN.uv_MainTex) * _Color;
			o.Albedo = c.rgb;
			// Metallic and smoothness come from slider variables
			o.Metallic = _Metallic;
			o.Smoothness = _Glossiness;
			o.Alpha = c.a;
		}
		ENDCG
		
			Cull Front
			CGPROGRAM
#pragma surface surf NoLighting  noambient

		struct Input {
			half2 uv_MainTex;
			float3 worldPos;

		};
		sampler2D _MainTex;
		fixed4 _Color;
		fixed4 _CrossColor;
		fixed3 _PlaneNormal;
		fixed3 _PlanePosition;
		bool checkVisability(fixed3 worldPos)
		{

			//float3 tmp1 = { worldPos.x, worldPos.y - 0.05, worldPos.z };
			//float3 tmp2 = { 0.0, worldPos.y - 0.05, 0.0 };
			float x1 = abs(worldPos.x - _PlanePosition.x);
			float z1 = abs(worldPos.z - _PlanePosition.z);
			float y1 = abs(_PlanePosition.y - worldPos.y);
			bool wow = ((x1 * x1) + (z1 * z1)) < ((y1 + 0.08) * (y1 + 0.08)) && ((x1 * x1) + (z1 * z1)) > ((y1) * (y1));
			//float dotProd1 = tmp.y;
			return (worldPos.y > _PlanePosition.y) || !wow;
			//float dotProd1 = dot(worldPos - _PlanePosition, _PlaneNormal);
			//return dotProd1 >0 ;
		}
		fixed4 LightingNoLighting(SurfaceOutput s, fixed3 lightDir, fixed atten)
		{
			fixed4 c;
			c.rgb = s.Albedo;
			c.a = s.Alpha;
			return c;
		}

		void surf(Input IN, inout SurfaceOutput o)
		{
			if (checkVisability(IN.worldPos))discard;
			o.Albedo = _CrossColor;

		}
			ENDCG
		
	}
	//FallBack "Diffuse"
}
